Option Explicit On 
Option Strict On

Public Class Form1
  Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call

  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub
  Private components As System.ComponentModel.IContainer

  'Required by the Windows Form Designer

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    '
    'Form1
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(6, 15)
    Me.ClientSize = New System.Drawing.Size(488, 400)
    Me.Name = "Form1"
    Me.Text = "Nested Class Demo"

  End Sub

#End Region

  Private Signal As Signal
  Private Signal2 As Signal

  Private Sub Form1_Paint(ByVal sender As Object, _
    ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint

    Signal.Draw(e.Graphics)
    Signal2.Draw(e.Graphics)

  End Sub

  Private Sub Form1_Load(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles MyBase.Load

    Signal = New Signal(New Rectangle(10, 10, 100, 300))
    AddHandler Signal.OnChange, AddressOf OnChange

    Threading.Thread.Sleep(1750)

    Signal2 = New Signal(New Rectangle(120, 10, 100, 300))
    AddHandler Signal2.OnChange, AddressOf OnChange
  End Sub


  Private Sub OnChange(ByVal sender As System.Object, _
    ByVal e As System.EventArgs)

    CType(sender, Signal).Draw(CreateGraphics())

  End Sub

  Private Sub Form1_Closed(ByVal sender As Object, _
    ByVal e As System.EventArgs) Handles MyBase.Closed
    Signal.Dispose()
    Signal2.Dispose()
  End Sub

End Class

Public Class Signal
#Region " Skadowe publiczne "
  Public Event OnChange(ByVal sender As System.Object, _
    ByVal e As System.EventArgs)

  Public Sub Draw(ByVal Graphic As Graphics)
    Graphic.FillRectangle(Brushes.Brown, Rect)
    DrawLights(Graphic)
  End Sub

  Public Sub New(ByVal Rect As Rectangle)
    FRect = Rect
    PositionLights()
    TurnOnGreen()
    CreateThread()
  End Sub

  Public Sub Dispose()
    Static Done As Boolean = False
    If (Done) Then Exit Sub
    Done = True
    KillThread()
    GC.SuppressFinalize(Me)
  End Sub

  Public Sub NextSignal()
    While (FThread.IsAlive)
      FThread.Sleep(SleepTime())
      ChangeState()
      DoChange()
    End While
  End Sub

#End Region

#Region " Skadowe chronione "

  ' Destruktor
  Protected Overrides Sub Finalize()
    Dispose()
  End Sub

  Protected Sub CreateThread()
    FThread = New Threading.Thread(AddressOf NextSignal)
    FThread.IsBackground = True
    StartSignal()
  End Sub

  Protected Sub StartSignal()
    FThread.Start()
  End Sub

  Protected Sub StopSignal()
    FThread.Abort()
    FThread.Join()
  End Sub

  Protected Sub KillThread()
    StopSignal()
    FThread = Nothing
  End Sub

  Protected Sub DrawLights(ByVal Graphic As Graphics)
    Dim I As Integer
    For I = 0 To FLights.GetUpperBound(0)
      FLights(I).Draw(Graphic)
    Next
  End Sub

#End Region

#Region " Skadowe prywatne "
  Private FLights() As Light = _
    {New GreenLight(), New YellowLight(), New RedLight()}
  Private FRect As Rectangle
  Private FThread As Threading.Thread

  Private ReadOnly Property Green() As Light
    Get
      Return FLights(0)
    End Get
  End Property

  Private ReadOnly Property Yellow() As Light
    Get
      Return FLights(1)
    End Get
  End Property

  Private ReadOnly Property Red() As Light
    Get
      Return FLights(2)
    End Get
  End Property

  Private ReadOnly Property Rect() As Rectangle
    Get
      Return FRect
    End Get
  End Property

  Private Sub PositionLights()

    Dim I As Integer
    For I = 0 To FLights.GetUpperBound(0)
      FLights(I).Rect = GetRect(I)
    Next

  End Sub

  Private Sub TurnOnGreen()
    Green.State = True
  End Sub

  Private Sub DoChange()
    RaiseEvent OnChange(Me, Nothing)
  End Sub


  Private Function GetRect(ByVal Index As Integer) As Rectangle
    Return New Rectangle(Rect.Left + 10, _
        Rect.Top + 10 + CInt(Math.Round((2 - Index) / 3 * Rect.Height)), _
        Rect.Width - 20, CInt(Math.Round(Rect.Height / 3)) - 20)
  End Function

  Private Sub ChangeState()
    Static Current As Integer = 0
    Current = (Current + 1) Mod 3
    Dim I As Integer

    For I = FLights.GetLowerBound(0) To _
      FLights.GetUpperBound(0)
      FLights(I).State = I = Current
    Next
  End Sub

  Private Function SleepTime() As Integer
    Static T() As Integer = {1000, 5000}
    If (Yellow.State) Then
      Return T(0)
    Else
      Return T(1)
    End If
  End Function

#End Region


#Region " Skadowe zagniedone "

  ' Virtual Abstract Nested Light Class
  ' Base class for the light signal light classes

  Private MustInherit Class Light
    Public State As Boolean = False
    Public Rect As Rectangle

    Protected MustOverride ReadOnly Property _
      BrushArray() As Brush()

    Protected Function GetBrush() As Brush

      If (State) Then
        Return BrushArray(1)
      Else
        Return BrushArray(0)
      End If
    End Function

    Public Sub Draw(ByVal Graphic As Graphics)
      Graphic.FillEllipse(GetBrush(), Rect)
    End Sub

    Protected Overrides Sub Finalize()
      Rect = Nothing
    End Sub
  End Class

  ' Zagniedona klasa RedLight, dziedziczy z Light
  Private Class RedLight
    Inherits Light

    Protected Overrides ReadOnly Property BrushArray() As Brush()
      Get
        Static Brush() As Brush = {Brushes.Gray, _
          Brushes.Red}
        Return Brush
      End Get
    End Property
  End Class

  ' Zagniedona klasa YellowLight, dziedziczy z Light
  Private Class YellowLight
    Inherits Light

    Protected Overrides ReadOnly Property BrushArray() As Brush()
      Get
        Static Brush() As Brush = {Brushes.Gray, _
          Brushes.Yellow}
        Return Brush
      End Get
    End Property

  End Class

  ' Zagniedona klasa GreenLight, dziedziczy z Light
  Private Class GreenLight
    Inherits Light
    Protected Overrides ReadOnly Property BrushArray() As Brush()
      Get
        Static Brush() As Brush = {Brushes.Gray, _
          Brushes.Green}
        Return Brush
      End Get
    End Property
  End Class
#End Region

End Class